import { App } from 'koishi';
import TargetPlugin from '../src';
import request from 'supertest';

describe('Test of plugin.', () => {
  let app: App;

  beforeEach(async () => {
    app = new App();
    app.plugin(TargetPlugin, { token: 'dress' });
    await app.start();
  });

  it('should check token', () => {
    request(app._httpServer)
      .post('/api')
      .send({ userId: '111111', content: 'wwww' })
      .expect(401);
    request(app._httpServer)
      .post('/api')
      .send({ userId: '111111', content: 'wwww' })
      .set('Authorization', 'dress')
      .expect(200);
    request(app._httpServer)
      .post('/api')
      .send({ userId: '111111', content: 'wwww' })
      .set('Authorization', 'Bearer dress')
      .expect(200);
    request(app._httpServer)
      .post('/api')
      .send({ userId: '111111', content: 'wwww' })
      .set('Authorization', 'Bearer skirt')
      .expect(401);
  });

  it('should reply message', () => {
    app.command('dress').action((a) => '梦梦女装！');
    request(app._httpServer)
      .post('/api')
      .send({ userId: '111111', content: 'dress' })
      .set('Authorization', 'dress')
      .expect(200)
      .expect({
        messages: ['梦梦女装！'],
      });
  });

  it('should correctly ref userId', () => {
    app.command('dress').action((a) => `${a.session.userId} 让梦梦女装！`);
    request(app._httpServer)
      .post('/api')
      .send({ userId: '111111', content: 'dress' })
      .set('Authorization', 'dress')
      .expect(200)
      .expect({
        messages: ['111111 让梦梦女装！'],
      });
  });

  it('should correctly ref groupId', () => {
    app.command('dress').action(async (a) => {
      await a.session.send('梦梦换衣服啦！');
      return '梦梦女装啦！';
    });
    request(app._httpServer)
      .post('/api')
      .send({ userId: '111111', content: 'dress' })
      .set('Authorization', 'dress')
      .expect(200)
      .expect({
        messages: ['梦梦换衣服啦！', '梦梦女装啦！'],
      });
  });

  afterEach(async () => {
    await app.stop();
    app._httpServer.close();
  });
});
