// import 'source-map-support/register';
import { ApiPluginConfig, ApiPluginConfigLike } from './config';
import {
  DefinePlugin,
  LifecycleEvents,
  Inject,
  InjectConfig,
} from 'koishi-thirdeye';
import { Adapter, Bot, Context, Random, Router } from 'koishi';
import { ApiSession } from './api-session';
export * from './config';

export class ApiBot extends Bot {
  username = 'koishi';
  selfId = 'koishi';
  hidden = true;

  constructor(public adapter: ApiAdapter, config: Bot.BaseConfig) {
    super(adapter, config);
  }

  async sendMessage(channelId: string, content: string) {
    return [];
  }

  async sendPrivateMessage(userId: string, content: string) {
    return [];
  }
}

export interface MessageBody {
  channelId?: string;
  guildId?: string;
  messageId?: string;
  content: string;
  userId?: string;
  username?: string;
  avatar?: string;
}

@DefinePlugin({ name: 'api', schema: ApiPluginConfig })
export default class ApiAdapter extends Adapter implements LifecycleEvents {
  constructor(ctx: Context, config: ApiPluginConfigLike) {
    super(ctx, config);
  }

  @Inject('bots', true)
  private botList: Adapter.BotList;

  @Inject(true)
  private router: Router;

  @InjectConfig()
  private pluginConfig: ApiPluginConfig;

  onApply() {
    this.platform = 'api';
    this.botList.adapters.api = this;
    const bot = this.botList.create('api', {}, ApiBot);

    this.router.post(this.pluginConfig.path, async (ctx) => {
      if (this.pluginConfig.token) {
        const tokenFromRequest = ctx.request.headers[
          'authorization'
        ]?.startsWith('Bearer ')
          ? ctx.request.headers['authorization'].slice(7)
          : '';
        if (tokenFromRequest !== this.pluginConfig.token) {
          ctx.status = 401;
          ctx.body = { error: 'Invalid token' };
          return;
        }
      }
      if (typeof ctx.request.body === 'string') {
        ctx.status = 400;
        ctx.body = { error: 'Invalid body' };
        return;
      }
      const body = ctx.request.body;
      if (!body.content) {
        ctx.status = 400;
        ctx.body = { error: 'Missing content.' };
        return;
      }
      const userId = body.userId || ctx.request.ip;
      const session = new ApiSession(bot, {
        userId,
        channelId: body.channelId || `private:${userId}`,
        guildId: body.guildId,
        messageId: body.messageId || Random.id(),
        content: body.content,
        platform: 'api',
        selfId: 'koishi',
        type: 'message',
        subtype: body.channelId ? 'group' : 'private',
        author: {
          userId,
          avatar: body.avatar,
          username: body.username || userId,
        },
      });
      await this.ctx.app.parallel('message', session);
      ctx.status = 200;
      ctx.body = { messages: session.getReponseMessages() };
    });
  }

  async start() {}

  async stop() {}
}
