import {
  Fragment,
  PromptOptions,
  Random,
  segment,
  SendOptions,
  Session,
} from 'koishi';
import ApiBot from './index';
import { Prompt } from './def/prompt';

export class ApiSession extends Session {
  storedMessages: string[] = [];
  private midResolver: () => void;
  bot: ApiBot;
  currentPromise: Promise<void>;

  midPromise = new Promise<void>((resolve) => {
    this.midResolver = resolve;
  });

  async waitForPattern() {
    await Promise.race([
      this.currentPromise.then(() => this.midResolve(true)),
      this.midPromise,
    ]);
    return this.gatherResponseMessages();
  }

  getIdentifier() {
    return '' + this.userId + this.channelId;
  }

  midResolve(finish = false) {
    if (!this.midResolver) {
      return;
    }
    this.midResolver();
    if (finish) {
      delete this.midResolver;
    } else {
      this.midPromise = new Promise<void>((resolve) => {
        this.midResolver = resolve;
      });
    }
  }

  async send(content: Fragment, options: SendOptions = {}) {
    if (!content) return;
    options.session = this;
    const children = await this.transform(segment.normalize(content));
    this.storedMessages.push(
      children.map((child) => child.toString()).join(''),
    );
    return [Random.id()];
  }

  gatherResponseMessages() {
    const result = this.storedMessages.filter((m) => !!m);
    this.storedMessages = [];
    return result;
  }

  prompt(...args: any[]) {
    const callback: (session: Session) => any =
      typeof args[0] === 'function'
        ? args.shift()
        : (session) => session.content;
    const options: PromptOptions =
      typeof args[0] === 'number' ? { timeout: args[0] } : args[0] ?? {};
    const timeout = options.timeout ?? this.app.config.delay.prompt;
    const identifier = this.getIdentifier();
    const prom = new Promise<string>((resolve) => {
      const prompt: Prompt = {
        resolver: resolve,
        timeout: setTimeout(() => {
          this.bot.resolvePrompt(identifier, undefined);
        }, timeout),
        session: this,
        contentCallback: callback,
      };
      this.bot.prompts.set(identifier, prompt);
    });
    this.midResolve();
    return prom;
  }
}
