import { App } from 'koishi';
import TargetPlugin from '../src';
import ConsolePlugin from '@koishijs/plugin-console';
import * as SandboxPlugin from '@koishijs/plugin-sandbox';
import DatabasePlugin from '@koishijs/plugin-database-memory';
// import CachePlugin from '@koishijs/plugin-cache-lru';
import ExtrasInDev from './extras';

const app = new App({
  port: 14514,
  host: 'localhost',
  prefix: '.',
});

// Console and sandbox
// app.plugin(SandboxPlugin);
app.plugin(ConsolePlugin, {
  open: false,
});
app.plugin(SandboxPlugin);

// Some services
// app.plugin(CachePlugin);
app.plugin(DatabasePlugin);

// Some extras
app.plugin(ExtrasInDev);

// Target plugin
app.plugin(TargetPlugin, {});

app.command('dress').action(async (a) => {
  await a.session.send('你好，我是小美女，我可以帮你穿衣服哦！');
  return `${a.session.username} 让梦梦女装！`;
});

app.command('boom').action((a) => {
  throw new Error('Boom!');
});

app.command('ask').action(async (a) => {
  await a.session.send(
    '你好，我是小美女，请问能告诉我你今天穿了什么颜色的衣服吗？',
  );
  const colorOfShirt = await a.session.prompt(100000);
  await a.session.send(`那你能告诉我你今天穿了什么颜色的裙子吗？`);
  const colorOfSkirt = await a.session.prompt(100000);
  return `原来 ${a.session.userId} 今天穿的是 ${colorOfShirt} 的衣服，和 ${colorOfSkirt} 的裙子！`;
});

app.start();
