# koishi-plugin-api

Koishi 作为 HTTP API 的插件，提供了一个简单的 HTTP API 接口，可以轻松接入其他聊天平台。

## 安装

### npm

```bash
npm install koishi-plugin-api
```

### 直接安装

在 https://cdn02.moecube.com:444/nanahira/koishi-plugin/api/index.js 下载即可。

## 配置

* `path` HTTP 监听路径。
* `token` 验证 Bearer 令牌。如果设置，则必须提供 `Authorization: Bearer <token>` 头。

## 使用

```ts
$ curl -X POST http://localhost:14514/api -d content=.help
{"messages":["当前可用的指令有：\n    help  显示帮助信息\n输入“帮助 指令名”查看特定指令的语法和使用示例。"]}
```

### 请求参数

```ts
export interface MessageBody {
  channelId?: string;
  guildId?: string;
  messageId?: string;
  content: string; // 消息体，必填
  userId?: string; // 发送者 ID，默认为请求 IP 地址
  username?: string;
  avatar?: string;
}
```

### 返回结果

```json
{
  "messages": [ 
    "消息内容，每一栏为一条消息。"
  ]
}
```
