// import 'source-map-support/register';
import { RegisterSchema, SchemaProperty } from 'koishi-thirdeye';
import { Bot, segment } from 'koishi';
import _ from 'lodash';
import { AlertDto } from './def';
import { SendTarget } from 'koishi-target-def';

@RegisterSchema()
export class InstanceConfig {
  @SchemaProperty({
    required: true,
    description: 'POST 的 Authorization Bearer 字段，用于标识不同路由。',
  })
  token: string;

  @SchemaProperty({
    description: '警报标题。',
    default: '警报',
  })
  title: string;

  @SchemaProperty({
    description: '解除警报的提示信息。',
    default: '警报已解除。',
  })
  resolvedMessage: string;

  @SchemaProperty({
    description: '使用 markdown 语法。',
    default: false,
  })
  markdown: boolean;

  formatAlert(dto: AlertDto) {
    const { alerts } = dto;
    let text = `# ${this.title}`;

    for (const alert of alerts) {
      const resolved = alert.status === 'resolved';
      text += `\n\n## ${resolved ? '[RESOLVED] ' : ''}${
        alert.annotations.summary || alert.labels.alertname
      }\n\n`;
      for (const [key, value] of Object.entries(alert.labels)) {
        // if (key === 'alertname') continue;
        text += `* ${key}: \`${value}\`\n`;
      }
      text += `\n`;
      if (resolved) {
        text += this.resolvedMessage;
        continue;
      }
      text += `${alert.annotations.description}`;
    }
    if (this.markdown) {
      text = segment('markdown', text).toString();
    }
    return text;
  }

  @SchemaProperty({
    type: SendTarget,
    description: '消息发送目标。',
    default: [],
  })
  targets: SendTarget[];

  async send(bots: Bot[], content: string) {
    return _.flatten(
      await Promise.all(
        this.targets.map((target) => target.send(bots, content)),
      ),
    );
  }
}

@RegisterSchema()
export class AlertmanagerPluginConfig {
  @SchemaProperty({
    description: '请求路径。',
    default: '/alertmanager',
  })
  path: string;
}
