import { Dict } from 'koishi';

export interface AlertDto {
  receiver: string;
  status: string;
  alerts: Alert[];
  groupLabels: GroupLabels;
  commonLabels: CommonLabels;
  commonAnnotations: CommonAnnotations;
  externalURL: string;
  version: string;
  groupKey: string;
  truncatedAlerts: number;
}

export type CommonAnnotations = Dict<string>;

export interface CommonLabels {
  alertname: string;
  severity: string;
}

export interface GroupLabels {
  alertname: string;
}

export interface Alert {
  status: string;
  labels: Labels;
  annotations: Annotations;
  startsAt: string;
  endsAt: string;
  generatorURL: string;
  fingerprint: string;
}

export interface Annotations {
  description: string;
  summary: string;
}

export interface Labels {
  alertname: string;
  instance: string;
  severity: string;
}
