// import 'source-map-support/register';
import { AlertmanagerPluginConfig, InstanceConfig } from './config';
import {
  DefinePlugin,
  StarterPlugin,
  Inject,
  LifecycleEvents,
  InjectLogger,
  MultiInstancePlugin,
  Post,
  KoaContext,
} from 'koishi-thirdeye';
import { Adapter, Logger, Router } from 'koishi';
import _ from 'lodash';
import { AlertDto } from './def';
export * from './config';

@DefinePlugin()
export class Instance extends StarterPlugin(InstanceConfig) {
  @Inject()
  private bots: Adapter.BotList;

  private async send(content: string) {
    return _.flatten(
      await Promise.all(
        this.config.targets.map((target) => target.send(this.bots, content)),
      ),
    );
  }

  trigger(body: AlertDto) {
    const content = this.config.formatAlert(body);
    return this.send(content);
  }

  isMatch(token: string) {
    return this.config.token === token;
  }
}

@DefinePlugin()
export default class AlertmanagerPlugin
  extends MultiInstancePlugin(Instance, AlertmanagerPluginConfig)
  implements LifecycleEvents
{
  @Inject(true)
  private bots: Adapter.BotList;

  @Inject(true)
  private router: Router;

  @InjectLogger()
  private logger: Logger;

  private getInstance(header: string) {
    const token = header?.startsWith('Bearer ') ? header.slice(7) : header;
    return this.instances.find((instance) => instance.isMatch(token));
  }

  @Post('{{path}}')
  async onAlert(ctx: KoaContext) {
    const instance = this.getInstance(ctx.headers['authorization']);
    if (!instance) {
      ctx.body = {
        status: 'error',
        error: 'unauthorized',
      };
      ctx.status = 403;
      return;
    }
    this.logger.warn(JSON.stringify(ctx.request.body));
    await instance.trigger(ctx.request.body);
    ctx.body = {
      status: 'success',
    };
    ctx.status = 200;
  }
}
