# koishi-plugin-alertmanager

Alertmanager Webhook 接收器。

## 安装

### npm

```bash
npm install koishi-plugin-alertmanager
```

### 直接安装

在 https://cdn02.moecube.com:444/nanahira/koishi-plugin/alertmanager/index.js 下载即可。

## 配置

### 插件配置

```yaml
path: '/alertmanager'
instances:
  - token: abcdefg # alertmanager 中的 credentials 字段
    title: '警报'
    targets: # 发送对象
      - bot: onebot:123456789
        users:
          - '111111111' # 私聊发送
        channels:
          - channelId: '222222222' # 群聊发送
            guildId: '333333333' # 可选，如果有两级群组的话
```

### alertmanager 配置 

```yaml
route:
  receiver: 'koishi'
  group_wait: 30s
  group_interval: 5m
  repeat_interval: 4h
  group_by: [cluster, alertname]
  
receivers:
  - name: koishi
    webhook_configs:
      - send_resolved: true
        url: http://koishi.example.com/alertmanager
        http_config:
          authorization:
            credentials: abcdefg
```
