// import 'source-map-support/register';
import { AlertmanagerPluginConfig } from './config';
import {
  DefinePlugin,
  BasePlugin,
  Post,
  Inject,
  LifecycleEvents,
  InjectLogger,
} from 'koishi-thirdeye';
import { Adapter, Logger, Router } from 'koishi';
export * from './config';

@DefinePlugin({ name: 'alertmanager', schema: AlertmanagerPluginConfig })
export default class AlertmanagerPlugin
  extends BasePlugin<AlertmanagerPluginConfig>
  implements LifecycleEvents
{
  @Inject(true)
  private bots: Adapter.BotList;

  @Inject(true)
  private router: Router;

  @InjectLogger()
  private logger: Logger;

  onApply() {
    this.router.post(this.config.path, async (ctx) => {
      const instance = this.config.getInstance(ctx.headers['authorization']);
      if (!instance) {
        ctx.body = {
          status: 'error',
          error: 'unauthorized',
        };
        ctx.status = 403;
        return;
      }
      this.logger.warn(`${JSON.stringify(ctx.request.body)}`);
      await instance.send(this.bots, instance.formatAlert(ctx.request.body));
      ctx.body = {
        status: 'success',
      };
      ctx.status = 200;
    });
  }
}
