import {
  DefinePlugin,
  StarterPlugin,
  UseEvent,
  InjectLogger,
} from 'koishi-thirdeye';
import { Logger, Session } from 'koishi';

@DefinePlugin({ name: 'addfriend' })
export default class AddFriendPlugin extends StarterPlugin() {
  @InjectLogger()
  private logger: Logger;

  @UseEvent('friend-request')
  onFriendRequest(session: Session) {
    this.logger.info(
      `${session.userId} requested to be ${session.selfId}'s friend.`,
    );
    return session.bot.handleFriendRequest(session.messageId, true);
  }
}
