// import 'source-map-support/register';
import { WecomEventBody, WecomEventResponse } from './def';
import { Adapter, Session } from 'koishi';
import HttpServer from './http';
import { BotConfig, WeComBot } from './bot';
import { AdapterConfig } from './utils';

declare module 'koishi' {
  interface Session {
    wecom?: WecomEventBody;
  }
  interface EventMap {
    'wecom/event'(session: Session): void;
    'wecom/message'(session: Session): void;
  }
}

export * from './def';
export * from './bot';
export * from './http';

export const adapterPlugin = Adapter.define<BotConfig, AdapterConfig>(
  'wecom',
  WeComBot,
  HttpServer,
);
export default adapterPlugin;
