import { WecomEventBody } from './def';
import { Session } from 'koishi';
import { ChangeContact } from './specific/ChangeContact';
import { ApprovalInfo } from './specific/ApprovalInfo';

type MayBeArray<T> = T | T[];

export interface EventKeyBody {
  EventKey: string;
}

export interface ScanCodeEventBody extends EventKeyBody {
  ScanCodeInfo: {
    ScanType: string;
    ScanResult: string;
  };
}

export interface PhotoEventBody extends EventKeyBody {
  SendPicsInfo: {
    Count: number;
    PicsList: {
      item: MayBeArray<{
        PicMd5Sum: string;
      }>;
    };
  };
}

export interface CardEventSelectedItems {
  SelectedItem: CardEventSelectedItem | CardEventSelectedItem[];
}

export interface CardEventSelectedItem {
  QuestionKey: string;
  OptionIds: CardEventOptionIds;
}

export interface CardEventOptionIds {
  OptionId: string | string[];
}

export interface CardMenuEvent extends EventKeyBody {
  TaskId: string;
  CardType: string;
  ResponseCode: number;
}

export interface CardEvent extends CardMenuEvent {
  SelectedItems: CardEventSelectedItems;
}

// eslint-disable-next-line @typescript-eslint/ban-types
export type WecomEventFunction<T = {}> = (
  session: Session & { wecom: WecomEventBody & T },
) => void;

export interface WecomInternalEvents {
  enter_agent: {};
  subscribe: {};
  unsubscribe: {};
  LOCATION: {
    Latitude: number;
    Longitude: number;
    Precision: number;
  };
  batch_job_result: {
    BatchJob: {
      JobId: string;
      JobType: string;
      ErrCode: number;
      ErrMsg: string;
    };
  };
  click: EventKeyBody;
  view: EventKeyBody;
  scancode_push: ScanCodeEventBody;
  scancode_waitmsg: ScanCodeEventBody;
  pic_sysphoto: PhotoEventBody;
  pic_photo_or_album: PhotoEventBody;
  pic_weixin: PhotoEventBody;
  location_select: EventKeyBody & {
    SendLocationInfo: {
      Location_X: number;
      Location_Y: number;
      Scale: number;
      Label: string;
      Poiname: string;
    };
  };

  share_agent_change: {};
  share_chain_change: {};
  template_card_event: CardEvent & {
    SelectedItems: CardEventSelectedItems;
  };

  template_card_menu_event: CardEvent;
  open_approval_change: {
    ApprovalInfo: ApprovalInfo;
  };
  change_contact: ChangeContact;
}

export type WecomEvents = {
  [K in keyof WecomInternalEvents as `wecom/${K}`]: WecomEventFunction<
    WecomInternalEvents[K]
  >;
};
