export interface WeComUser {
  errcode: number;
  errmsg: string;
  userid: string;
  name: string;
  department: number[];
  order: number[];
  position: string;
  mobile: string;
  gender: string;
  email: string;
  biz_mail: string;
  is_leader_in_dept: number[];
  direct_leader: string[];
  avatar: string;
  thumb_avatar: string;
  telephone: string;
  alias: string;
  address: string;
  open_userid: string;
  main_department: number;
  extattr: Extattr;
  status: number;
  qr_code: string;
  external_position: string;
  external_profile: Externalprofile;
}

interface Externalprofile {
  external_corp_name: string;
  wechat_channels: Wechatchannels;
  external_attr: Externalattr[];
}

interface Externalattr {
  type: number;
  name: string;
  text?: Text;
  web?: Web;
  miniprogram?: Miniprogram;
}

interface Miniprogram {
  appid: string;
  pagepath: string;
  title: string;
}

interface Wechatchannels {
  nickname: string;
  status: number;
}

interface Extattr {
  attrs: Attr[];
}

interface Attr {
  type: number;
  name: string;
  text?: Text;
  web?: Web;
}

interface Web {
  url: string;
  title: string;
}

interface Text {
  value: string;
}
