import { App, segment } from 'koishi';
import ExtrasInDev from './extras';
import { adapterPlugin } from '../src';
import * as fs from 'fs';

const app = new App({
  port: 3000,
  host: '0.0.0.0',
  prefix: '.',
});

// Some extras
app.plugin(ExtrasInDev);

// Target plugin
app.plugin(adapterPlugin, {
  bots: [
    {
      corpId: 'corpId', // 企业 ID，在企业信息 https://work.weixin.qq.com/wework_admin/frame#profile 中查看
      agentId: 'agentId', // 应用 ID，在应用管理中查看
      secret: 'secret', // 应用密钥，在应用管理中查看
    },
  ],
  path: '/wecom', // 回调 API 路径
  token: 'token', // 回调 API token，在应用消息接收设置中设置并填入
  encodingAESKey: 'encodingAESKey', // 加密密钥，在应用消息接收设置中设置并填入
});

app.on('wecom/event', (session) => {
  console.log(`Got event ${JSON.stringify(session.wecom)}`);
});

app.on('message', (session) => {
  console.log(`Got message ${session.content}`);
});

app
  .command('test1')
  .action(async () =>
    segment.image(await fs.promises.readFile(__dirname + '/10000.jpg')),
  );

app
  .command('test2')
  .action(async () =>
    segment.image(
      'https://cdn02.moecube.com:444/images/ygopro-images-zh-CN/10000.jpg',
    ),
  );

app.start();
