import { App, segment } from 'koishi';
import ExtrasInDev from './extras';
import { adapterPlugin } from '../src';
import * as fs from 'fs';

const app = new App({
  port: 3000,
  host: '0.0.0.0',
  prefix: '.',
});

// Some extras
app.plugin(ExtrasInDev);

// Target plugin
app.plugin(adapterPlugin, {
  bots: [
    {
      corpId: 'corpId', // 企业 ID，在企业信息 https://work.weixin.qq.com/wework_admin/frame#profile 中查看
      agentId: 'agentId', // 应用 ID，在应用管理中查看
      secret: 'secret', // 应用密钥，在应用管理中查看
      menus: [
        {
          type: 'view', // 打开网页
          name: 'MyCard', // 按钮名称
          url: 'https://mycard.moe', // 网页地址
        },
        {
          type: 'click', // 运行指令
          name: '看图', // 按钮名称
          command: 'media -c 10000000', // 指令
        },
        {
          type: 'parent', // 子指令
          name: '更多', // 按钮名称
          children: [
            { type: 'click', name: '点击事件', command: 'markdown' },
            { type: 'scancode_push', name: '扫一扫' }, // 扫一扫并打开网页。
            { type: 'scancode_waitmsg', name: '扫一扫2', command: 'scan' }, // 扫一扫并运行指令。
            { type: 'location_select', name: '地理位置', command: 'location' }, // 选择地理位置并运行指令。
          ],
        },
      ],
    },
  ],
  path: '/wecom', // 回调 API 路径
  token: 'token', // 回调 API token，在应用消息接收设置中设置并填入
  encodingAESKey: 'encodingAESKey', // 加密密钥，在应用消息接收设置中设置并填入
});

app.on('wecom/LOCATION', (session) => {
  console.log(
    `Got location for ${session.userId}: ${session.wecom.Longitude} ${session.wecom.Latitude}`,
  );
});

app.on('wecom/click', (session) => {
  console.log(`${session.userId} clicked ${session.wecom.EventKey}`);
});

app.on('message', (session) => {
  console.log(`Got message ${session.content}`);
});

app
  .command('image')
  .action(async () =>
    segment.image(await fs.promises.readFile(__dirname + '/10000.jpg')),
  );

app.command('markdown').action(async () => {
  return `${segment('markdown')}# 女装\n> 今天梦梦女装了吗？`;
});

app
  .command('scan')
  .action(
    (argv) => `扫出来了: ${argv.session.wecom['ScanCodeInfo']['ScanResult']}`,
  );

app.command('location').action(async (argv) => {
  const { session } = argv;
  return `你的位置是 ${session.wecom['SendLocationInfo']['Label']}，经纬度是 ${session.wecom['SendLocationInfo']['Location_X']} ${session.wecom['SendLocationInfo']['Location_Y']}`;
});

app
  .command('media')
  .option('type', '-t <type:string>', { fallback: 'image' })
  .option('cardcode', '-c <cardcode:string>', { fallback: '10000' })
  .action(async (argv) =>
    segment(argv.options.type, {
      url: `https://cdn02.moecube.com:444/images/ygopro-images-zh-CN/${argv.options.cardcode}.jpg`,
    }),
  );

app.start();
