# koishi-plugin-adapter-wecom

Koishi 企业微信适配器。

## 安装

### npm

```bash
npm install koishi-plugin-adapter-wecom
```

## 配置

在企业微信后台中 [应用管理](https://work.weixin.qq.com/wework_admin/frame#apps) 中创建企业自建应用，并配置 API 接收消息，填入配置中即可。

```ts
{
  bots: [
    {
      corpId: 'corpId', // 企业 ID，在企业信息 https://work.weixin.qq.com/wework_admin/frame#profile 中查看
      agentId: 'agentId', // 应用 ID，在应用管理中查看
      secret: 'secret', // 应用密钥，在应用管理中查看
      menus: [
        {
          type: 'view', // 打开网页
          name: 'MyCard', // 按钮名称
          url: 'https://mycard.moe', // 网页地址
        },
        {
          type: 'click', // 运行指令
          name: '看图', // 按钮名称
          command: 'media -c 10000000', // 指令
        },
        {
          type: 'parent', // 子指令
          name: '更多', // 按钮名称
          children: [
            { type: 'click', name: '点击事件', command: 'markdown' },
            { type: 'scancode_push', name: '扫一扫' }, // 扫一扫并打开网页。
            { type: 'scancode_waitmsg', name: '扫一扫2', command: 'scan' }, // 扫一扫并运行指令。
            { type: 'location_select', name: '地理位置', command: 'location' }, // 选择地理位置并运行指令。
          ],
        },
      ],
    },
  ],
  path: '/wecom', // 回调 API 路径
  token: 'token', // 回调 API token，在应用消息接收设置中设置并填入
  encodingAESKey: 'encodingAESKey', // 加密密钥，在应用消息接收设置中设置并填入
}
```

## 事件

* `wecom/{Event}`：企业微信事件，以 `wecom/` 开头，参考 [企业微信文档](https://developer.work.weixin.qq.com/document/path/90240) 。
