import { WecomEventBody } from './def';
import { Session } from 'koishi';

type MayBeArray<T> = T | T[];

export interface EventKeyBody {
  EventKey: string;
}

export interface ScanCodeEventBody extends EventKeyBody {
  ScanCodeInfo: {
    ScanType: string;
    ScanResult: string;
  };
}

export interface PhotoEventBody extends EventKeyBody {
  SendPicsInfo: {
    Count: number;
    PicsList: {
      item: MayBeArray<{
        PicMd5Sum: string;
      }>;
    };
  };
}

export interface CardEventSelectedItems {
  SelectedItem: CardEventSelectedItem | CardEventSelectedItem[];
}

export interface CardEventSelectedItem {
  QuestionKey: string;
  OptionIds: CardEventOptionIds;
}

export interface CardEventOptionIds {
  OptionId: string | string[];
}

export interface CardMenuEvent extends EventKeyBody {
  TaskId: string;
  CardType: string;
  ResponseCode: number;
}

export interface CardEvent extends CardMenuEvent {
  SelectedItems: CardEventSelectedItems;
}

// eslint-disable-next-line @typescript-eslint/ban-types
export type WecomEventFunction<T = {}> = (
  session: Session & { wecom: WecomEventBody & T },
) => void;
