export interface WecomApiResponse {
  errcode: number;
  errmsg: string;
}

export interface WecomReceiveMessageDto {
  msg_signature: string;
  timestamp: number;
  nonce: number;
}

export interface WecomRegisterDto extends WecomReceiveMessageDto {
  echostr: string;
}

export interface WecomDecodedMessage {
  message: string;
  id: string;
  random: Buffer;
}

export type WecomEventResponse = WecomResponse<WecomEventBody>;

export interface WecomResponse<T> {
  ToUserName: string;
  AgentID: number;
  Encrypt: string;
  data?: WecomDecodedMessage;
  body?: T;
}

export interface WecomEventBody {
  ToUserName: string;
  FromUserName: string;
  CreateTime: number;
  MsgType: string;
  Event?: string;
  AgentID: number;
  MsgId?: number;
  EventKey?: string;
}

export interface WecomChatBody extends WecomEventBody {
  Content: string;
}

export interface WecomMediaBody extends WecomEventBody {
  MediaId: number;
}

export interface WecomPicBody extends WecomMediaBody {
  PicUrl: string;
}

export interface WecomLinkBody extends WecomEventBody {
  Title: string;
  Description: string;
  Url: string;
  PicUrl: string;
}

export interface CardEventSelectedItems {
  SelectedItem: CardEventSelectedItem | CardEventSelectedItem[];
}

export interface CardEventSelectedItem {
  QuestionKey: string;
  OptionIds: CardEventOptionIds;
}

export interface CardEventOptionIds {
  OptionId: string | string[];
}

export interface WecomCardEventBody extends WecomEventBody {
  TaskId: string;
  CardType: string;
  SelectedItems?: CardEventSelectedItems;
}

export interface WecomLocationBody extends WecomEventBody {
  Latitude: number;
  Longitude: number;
  Precision: number;
}

export interface TokenReturnMessage extends WecomApiResponse {
  access_token: string;
  expires_in: number;
}

export interface OutMessage {
  msgtype: string;
  agentid: string;
  touser?: string;
  toparty?: string;
  totag?: string;
}

export interface CommonOutMessage extends OutMessage {
  msgtype: 'markdown';
  markdown: { content: string };
}

export interface TextOutMessage extends OutMessage {
  msgtype: 'text';
  text: { content: string };
}

export interface MediaIdObject {
  media_id: string;
}

export interface ImageOutMessage extends OutMessage {
  msgtype: 'image';
  image: MediaIdObject;
}

export interface VideoOutMessage extends OutMessage {
  msgtype: 'video';
  video: MediaIdObject;
}

export interface WecomSendMessageResponse extends WecomApiResponse {
  invaliduser: string;
  invalidparty: string;
  invalidtag: string;
  msgid: string;
  response_code: string;
}

export interface WecomMediaUploadResponse extends WecomApiResponse {
  type: string;
  media_id: string;
  created_at: string;
}
