# koishi-plugin-adapter-wecom

Koishi 企业微信适配器。

## 安装

### npm

```bash
npm install koishi-plugin-adapter-wecom
```

## 配置

在企业微信后台中 [应用管理](https://work.weixin.qq.com/wework_admin/frame#apps) 中创建企业自建应用，并配置 API 接收消息，填入配置中即可。

```ts
{
  bots: [
    {
      corpId: 'corpId', // 企业 ID，在企业信息 https://work.weixin.qq.com/wework_admin/frame#profile 中查看
      agentId: 'agentId', // 应用 ID，在应用管理中查看
      secret: 'secret', // 应用密钥，在应用管理中查看
    },
  ],
  path: '/wecom', // 回调 API 路径
  token: 'token', // 回调 API token，在应用消息接收设置中设置并填入
  encodingAESKey: 'encodingAESKey', // 加密密钥，在应用消息接收设置中设置并填入
}
```

