import { ChangeContactUser } from './ChangeContactUser';

export * from './ChangeContactUser';

export type ChangeContact<
  K extends keyof ChangeContactMap = keyof ChangeContactMap,
> = {
  ChangeType: K;
} & ChangeContactMap[K];

export interface ChangeContactParty {
  Id: number;
  Name: string;
  ParentId: number;
}

export interface ChangeContactMap {
  create_user: ChangeContactUser;
  update_user: ChangeContactUser;
  delete_user: {
    UserID: string;
  };
  create_party: ChangeContactParty & { Order: number };
  update_party: ChangeContactParty;
  delete_party: {
    Id: number;
  };
  update_tag: {
    TagId: number;
    AddUserItems: string;
    DelUserItems: string;
    AddPartyItems: string;
    DelPartyItems: string;
  };
}
