// import 'source-map-support/register';
import {
  ApprovalInfo,
  CardEvent,
  CardEventSelectedItems,
  ChangeContact,
  EventKeyBody,
  PhotoEventBody,
  ScanCodeEventBody,
  WecomEventBody,
  WecomEventFunction,
} from './def';
import { Adapter } from 'koishi';
import HttpServer from './http';
import { BotConfig, WeComBot } from './bot';
import { AdapterConfig } from './utils';

declare module 'koishi' {
  interface Session {
    wecom?: WecomEventBody;
  }
  interface EventMap {
    'wecom/enter_agent': WecomEventFunction;
    'wecom/subscribe': WecomEventFunction;
    'wecom/unsubscribe': WecomEventFunction;
    'wecom/LOCATION': WecomEventFunction<{
      Latitude: number;
      Longitude: number;
      Precision: number;
    }>;
    'wecom/batch_job_result': WecomEventFunction<{
      BatchJob: {
        JobId: string;
        JobType: string;
        ErrCode: number;
        ErrMsg: string;
      };
    }>;
    'wecom/click': WecomEventFunction<EventKeyBody>;
    'wecom/view': WecomEventFunction<EventKeyBody>;
    'wecom/scan': WecomEventFunction<ScanCodeEventBody>;
    'wecom/scancode_waitmsg': WecomEventFunction<ScanCodeEventBody>;
    'wecom/pic_sysphoto': WecomEventFunction<PhotoEventBody>;
    'wecom/pic_photo_or_album': WecomEventFunction<PhotoEventBody>;
    'wecom/pic_weixin': WecomEventFunction<PhotoEventBody>;
    'wecom/location_select': WecomEventFunction<
      EventKeyBody & {
        SendLocationInfo: {
          Location_X: number;
          Location_Y: number;
          Scale: number;
          Label: string;
          Poiname: string;
        };
      }
    >;
    'wecom/share_agent_change': WecomEventFunction;
    'wecom/share_chain_change': WecomEventFunction;
    'wecom/template_card_event': WecomEventFunction<
      CardEvent & {
        SelectedItems: CardEventSelectedItems;
      }
    >;
    'wecom/template_card_menu_event': WecomEventFunction<CardEvent>;
    'wecom/open_approval_change': WecomEventFunction<{
      ApprovalInfo: ApprovalInfo;
    }>;
    'wecom/change_contact': WecomEventFunction<ChangeContact>;
  }
}

export * from './def';
export * from './bot';
export * from './http';

export const adapterPlugin = Adapter.define<BotConfig, AdapterConfig>(
  'wecom',
  WeComBot,
  HttpServer,
);
export default adapterPlugin;
