import { Element } from 'koishi';

const patternTypes = ['message', 'p'];

export function getFirstElement(elements: Element[]): Element {
  if (!elements.length) return;
  const firstElement = elements[0];
  if (patternTypes.includes(firstElement.type)) {
    const innerFirst = getFirstElement(firstElement.children);
    if (innerFirst) return innerFirst;
    return getFirstElement(elements.slice(1));
  }
  return firstElement;
}

export function getPlainText(elements: Element[]) {
  let buffer = '';
  for (const element of elements) {
    if (element.type === 'text') {
      buffer += element.attrs.content;
    } else if (element.type === 'a') {
      buffer += element.toString();
    } else if (patternTypes.includes(element.type)) {
      buffer += getPlainText(element.children);
      buffer += '\n';
    } else if (element.type === 'at') {
      if (element.attrs.id) {
        buffer += `@${element.attrs.id}`;
      } else if (element.attrs.type === 'all') {
        buffer += '@全体成员';
      } else if (element.attrs.type === 'here') {
        buffer += '@在线成员';
      } else if (element.attrs.role) {
        buffer += `@${element.attrs.role}`;
      }
    } else if (element.type === 'sharp') {
      buffer += ` #${element.attrs.name} `;
    } else {
      buffer += getPlainText(element.children);
    }
  }
  return buffer.trim();
}
