import { Adapter, segment } from 'koishi';
import { DefinePlugin, Reusable } from 'koishi-thirdeye';
import type WechatBot from './index';

@Reusable()
@DefinePlugin()
export class WechatAdapter extends Adapter.Client<WechatBot> {
  async start(bot: WechatBot) {
    bot.internal.subscribe((acc) =>
      bot.handleSession(acc, { type: 'wechat:subscribe' }),
    );
    bot.internal.unsubscribe((acc) =>
      bot.handleSession(acc, { type: 'wechat:unsubscribe' }),
    );
    bot.internal.text(/.*/, (acc) =>
      bot.handleSession(acc, {
        type: 'message',
        content: acc.content,
      }),
    );
    bot.internal.image((acc) =>
      bot.handleSession(acc, {
        type: 'message',
        content: segment.image(acc.picUrl).toString(),
      }),
    );
    bot.internal.video(async (acc) => {
      const content = await bot.transformVideo(acc.mediaId);
      if (content) {
        await bot.handleSession(acc, {
          type: 'message',
          content: content.toString(),
        });
      }
    });
    bot.internal.voice(async (acc) => {
      const content = await bot.transformVoice(acc.mediaId);
      if (content) {
        await bot.handleSession(acc, {
          type: 'message',
          content: content.toString(),
        });
      }
    });
    bot.internal.menu((acc) => bot.handleMenu(acc));
    await bot.initialize();
  }

  async stop(bot: WechatBot) {}
}
