// import 'source-map-support/register';
import { RegisterSchema, SchemaProperty } from 'koishi-thirdeye';

import WechatApplication from 'koa-wechat-public';
import { WechatMenuDef } from './utils/menu';

@RegisterSchema()
export class WechatOfficialConfig
  implements WechatApplication.WechatApplicationConfig
{
  constructor(config: WechatOfficialConfigLike) {}

  @SchemaProperty({
    description: '回调路径。每个 bot 必须唯一。',
    required: true,
  })
  path: string;

  @SchemaProperty({ description: '微信公众号 ID。', required: true })
  appId: string;
  @SchemaProperty({
    description: '微信公众号 Secret。',
    required: true,
    role: 'secret',
  })
  appSecret: string;
  @SchemaProperty({
    description: '微信公众号 Token。',
    required: true,
    role: 'secret',
  })
  token: string;
  @SchemaProperty({
    description: '微信公众号 AES Key。如果开启加密模式需要用到该项。',
    role: 'secret',
  })
  encodingAESKey?: string;

  @SchemaProperty({
    description: '微信公众号菜单配置。',
    type: WechatMenuDef,
    default: [],
  })
  menus?: WechatMenuDef[];

  platform = 'wechat-official';
  get selfId() {
    return this.appId;
  }
}

export type WechatOfficialConfigLike = Partial<WechatOfficialConfig>;
