import { App, segment } from 'koishi';
import TargetPlugin from '../src';
import * as Help from '@koishijs/plugin-help';
import ExtrasInDev from './extras';
import * as fs from 'fs';

const app = new App({
  port: 3000,
  host: '0.0.0.0',
  prefix: '.',
});

app.plugin(Help);

// Some extras
app.plugin(ExtrasInDev);

// Target plugin
app.plugin(TargetPlugin, {
  path: '/wechat',
  token: 'token',
  appId: 'appId',
  appSecret: 'appSecret',
  menus: [
    {
      type: 'click',
      name: '帮助',
      command: 'help',
    },
    {
      type: 'click',
      name: '卡片调查',
      command: 'survey',
    },
    {
      type: 'parent',
      name: '卡图预览',
      children: [
        {
          type: 'click',
          name: '巨神兵',
          command: 'obelisk',
        },
        {
          type: 'click',
          name: '天空龙',
          command: 'silfer',
        },
        {
          type: 'click',
          name: '翼神龙',
          command: 'ra',
        },
      ],
    },
  ],
});

app.on('wechat:subscribe', (session) => {
  console.log(`subscribe: ${session.userId}`);
  return session.send('欢迎关注！');
});

app.on('wechat:unsubscribe', (session) =>
  console.log(`unsubscribe: ${session.userId}`),
);

app.on('message', (session) =>
  console.log(`message from ${session.userId}: ${session.content}`),
);

app
  .command('obelisk', '巨神兵')
  .action(({ session }) =>
    segment.image(
      'https://cdn02.moecube.com:444/images/ygopro-images-zh-CN/10000000.jpg',
    ),
  );

app
  .command('silfer', '天空龙')
  .action(({ session }) =>
    segment.image(fs.readFileSync('./dev/pics/10000020.jpg'), 'image/jpeg'),
  );

app
  .command('ra', '翼神龙')
  .action(({ session }) =>
    segment.image(`file://${process.cwd()}/dev/pics/10000010.jpg`),
  );

app.command('survey', '卡片调查').action(async ({ session }) => {
  await session.send('你喜欢什么游戏王卡？');
  const card = await session.prompt();
  await session.send(`你喜欢的卡是 ${card} 吗？`);
  const confirm = await session.prompt();
  if (confirm === '是') {
    return '谢谢你的反馈！你最喜欢的卡是: ' + card;
  } else {
    return '谢谢你的反馈！';
  }
});

app.command('link').action(() => '<a href="https://koishi.chat">Koishi</a>');

app.command('wait <time:posint>').action(async (argv, time) => {
  await new Promise((resolve) => setTimeout(resolve, time * 1000));
  return `等待了 ${time} 秒`;
});

app.start();
