import * as fs from 'fs';
import { Playbook } from '../src/playbook/Playbook';
import { classToPlain, plainToClass } from 'class-transformer';
import delay from 'delay';

async function main() {
  const content = await fs.promises.readFile(
    './test/test-playbook.txt',
    'utf-8',
  );
  const playbook = new Playbook();
  playbook.loadText(content);
  playbook.tuneTime({
    readSlope: 0,
    readIntercept: 1,
    writeSlope: 1,
    writeIntercept: 2,
    maxRandomDelay: 5,
  });
  const plain = classToPlain(playbook);
  playbook.characters.forEach(
    (c) =>
      (c.playFun = async (l, text) =>
        console.error(`${c.getDisplayName()}: ${text}`)),
  );
  for (let i = 0; ; i++) {
    if (await playbook.play(i)) {
      break;
    }
    await delay(1000);
  }
}
main();
