import { matchHeader, render } from './utility';
import { Character } from './Character';

export class PlaybookLine {
  characterId?: number;
  name?: string;
  content = '';
  time = 0;
  static FromLines(lines: string[]) {
    const l = new PlaybookLine();
    l.fromLines(lines);
    return l;
  }
  fromLines(lines: string[]) {
    const header = lines[0];
    this.content = lines
      .slice(1)
      .filter((l) => l.length)
      .join('\n');
    const headerMatch = matchHeader(header);
    if (!headerMatch) {
      this.name = header;
      return;
    }
    this.name = headerMatch[1];
    this.time =
      parseInt(headerMatch[4]) * 3600 +
      parseInt(headerMatch[5]) * 60 +
      parseInt(headerMatch[6]);
    if (
      (headerMatch[3] === '下午' || headerMatch[8] === 'PM') &&
      headerMatch[4] !== '12'
    ) {
      this.time += 12 * 3600;
    }
  }
  transferName(characters: Character[]) {
    this.characterId = characters.findIndex((c) => c.name === this.name);
    for (let i = 0; i < characters.length; ++i) {
      this.content = this.content.replace(
        new RegExp(characters[i].name, 'g'),
        `{{${i}}}`,
      );
    }
    this.name = undefined;
  }
  renderContent(characters: Character[]) {
    const view: Record<number, string> = {};
    for (const c of characters) {
      view[c.id] = c.name;
    }
    return render(this.content, view);
  }
  play(characters: Character[]) {
    const character = characters.find((c) => c.id === this.characterId);
    if (!character) {
      return;
    }
    return character.play(this, this.renderContent(characters));
  }
}
