import Mustache from 'mustache';

export function matchHeader(input: string) {
  return input
    .trim()
    .match(/^(.+?) +((上午|下午) ?)?(\d{1,2}):(\d{1,2}):(\d{1,2})( (AM|PM))?$/);
}

export function render(template: string, view: any) {
  return Mustache.render(template, view, null, { escape: (v) => v });
}

export interface TuneTimeOptions {
  readSlope: number;
  readIntercept: number;
  writeSlope: number;
  writeIntercept: number;
  maxRandomDelay: number;
}
