# koishi-plugin-act

小剧场公演插件。

这个插件只能在 OneBot 运行，需要提前设置好剧本。

公演剧本可以通过 https://www.wenaiwu.net/pb/ 粘贴聊天记录生成。

## 安装

### npm

```bash
npm install koishi-plugin-act
```

### 直接安装

在 https://cdn01.moecube.com/nanahira/koishi-plugin/act/index.js 下载，并配置 `koishi.config.js` 。

```js
module.exports = {
    plugins: { 
        "/path/to/act/index.js": {
            adminContext: (ctx) => ctx.private(),
              autoChangeName: true,
              dropHelp: false,
              playbookPathPrefix: './playbooks'
        }
    }
}
```

## 配置

```ts
export interface Config {
  adminContext: (ctx: Context) => Context;
  autoChangeName: boolean;
  dropHelp: boolean;
  playbookPathPrefix: string;
}
```

### 说明

* `adminContext` 管理员接口作用域。

* `autoChangeName` 公演开始之前是否修改每个演员机器人的群名片。推荐开启。

* `dropHelp` 是否删除 `help` 命令，避免社死 (?)

* `playbookPathPrefix` 公演剧本存放路径。公演剧本的文件名是 `/path/to/playbookPathPrefix/name.json` 对应于 name 剧本。

## 命令

* `act [groupId:number]` 获取公演状态。不带参数获取所有正在公演的群，带参数则获取特定群。

* `act.create <groupId:number> <playbookFilename:string> [...specificCharacters]` 创建公演
  * `groupId` 目标群。`playbookFilename` 是公演剧本文件，需要在服务器放好。后面的参数可以以 人物名=帐号 的形式指定特定的人物，否则随机分配。
    * 例: `act.create 11111111 play1 幽幽子=2222222` 在群 11111111 创建一个公演，剧本是 play1，位于 `/path/to/playbookPathPrefix/play1.json`，同时指定人物幽幽子为 2222222 扮演。

* `.delete <groupId:number>` 停止公演。
