import { ModelClassType, ModelFieldDef } from './def';
import { Metadata } from './meta/meta';
import { Flatten, Keys } from 'minato';
import { inferType } from './utils';

export class ModelDecorators<Tables = any> {
  DefineModel = (name: Keys<Tables>): ClassDecorator =>
    Metadata.set('ModelTableName', name);

  ModelField =
    <T = any>(def?: ModelFieldDef<T>): PropertyDecorator =>
    (obj, key) =>
      Metadata.set(
        'ModelField',
        def || inferType(Reflect.getMetadata('design:type', obj, key)),
        'ModelFieldKeys',
      )(obj, key);

  Primary = (): PropertyDecorator =>
    Metadata.set('ModelPrimaryKey', { autoIncrement: false });

  PrimaryGenerated = (): PropertyDecorator =>
    Metadata.set('ModelPrimaryKey', { autoIncrement: true });

  Foreign = <K extends Keys<Tables>>(
    referencingTable: K,
    referencingColumn: Keys<Flatten<Tables[K]>>,
  ): PropertyDecorator =>
    Metadata.set('ModelForeignKey', [referencingTable, referencingColumn]);

  Unique = (identifier: string | number = '_default'): PropertyDecorator =>
    Metadata.append('ModelUnique', identifier);

  ChildModel =
    (cls?: ModelClassType): PropertyDecorator =>
    (obj, key) => {
      if (!cls) {
        cls = Reflect.getMetadata('design:type', obj, key);
      }
      Metadata.set('ChildModel', cls, 'ChildModelKeys')(obj, key);
    };
}
