import { Field } from 'cosmotype';

type Shorthand<S extends string> = S | `${S}(${any})`;

export type ModelFieldDef<T = any> = Field<T> | Shorthand<Field.Type<T>>;

export type ModelClassType<T = any> = { new (...args: any[]): T };

export interface PrimaryKeyDef {
  autoIncrement: boolean;
}
