import { ModelClassType, ModelFieldDef } from './def';
import { Metadata } from './meta/meta';
import { Flatten, Keys, Tables } from 'koishi';
import { inferType } from './utils';

export const DefineModel = (name: Keys<Tables>): ClassDecorator =>
  Metadata.set('ModelTableName', name);

export const ModelField =
  <T = any>(def?: ModelFieldDef<T>): PropertyDecorator =>
  (obj, key) =>
    Metadata.set(
      'ModelField',
      def || inferType(Reflect.getMetadata('design:type', obj, key)),
      'ModelFieldKeys',
    )(obj, key);

export const Primary = (): PropertyDecorator =>
  Metadata.set('ModelPrimaryKey', { autoIncrement: false });

export const PrimaryGenerated = (): PropertyDecorator =>
  Metadata.set('ModelPrimaryKey', { autoIncrement: true });

export const Foreign = <K extends Keys<Tables>>(
  referencingTable: K,
  referencingColumn: Keys<Flatten<Tables[K]>>,
): PropertyDecorator =>
  Metadata.set('ModelForeignKey', [referencingTable, referencingColumn]);

export const Unique = (
  identifier: string | number = '_default',
): PropertyDecorator => Metadata.append('ModelUnique', identifier);

export const ChildModel =
  (cls?: ModelClassType): PropertyDecorator =>
  (obj, key) => {
    if (!cls) {
      cls = Reflect.getMetadata('design:type', obj, key);
    }
    Metadata.set('ChildModel', cls, 'ChildModelKeys')(obj, key);
  };
