import { ModelFieldDef } from '../def';

// eslint-disable-next-line @typescript-eslint/ban-types
export function inferType(type: Function): ModelFieldDef {
  switch (type) {
    case String:
      return 'string';
    case Number:
      return 'integer';
    case Boolean:
      return 'integer(4)';
    case Date:
      return 'timestamp';
    case Array:
      return 'list';
    default:
      return 'json';
  }
}
