import { Model, Field } from '@minatojs/core';

export type Internal<O = any> = {
  [K in keyof O]?: O[K] extends (...args: any) => any ? O[K] : never;
};

declare module '@minatojs/core' {
  interface Model<S> {
    internal: Internal<S>;
  }
}

// eslint-disable-next-line @typescript-eslint/ban-types
Model.prototype.parse = function (this: Model, source: object) {
  const result: any = Object.create(this.internal?.[''] ?? {});
  for (const key in source) {
    let node = result;
    const segments = key.split('.').reverse();
    let prefix = '';
    for (let index = segments.length - 1; index > 0; index--) {
      const segment = segments[index];
      prefix += segment + '.';
      node = node[segment] ??= Object.create(this.internal?.[prefix] ?? {});
    }
    if (key in source) {
      const value = this.resolveValue(key, source[key]);
      node[segments[0]] = value;
    }
  }
  return result;
};
