import { TopLevelAction } from '../src/decorators';
import { Registrar } from '../src/register';
import { App } from 'koishi';

@TopLevelAction((ctx, o) => (o.foo += 1))
@TopLevelAction((ctx, o) => (o.bar += 2))
class MyClass {
  foo = 0;
  bar = 0;
}

@TopLevelAction((ctx, o) => (o.baz += 3))
class MyAnotherClass extends MyClass {
  baz = 0;
}

class UnrelatedClass {
  foo = 0;
  bar = 0;
}

describe('Top level action', () => {
  it('should be applied to the class', () => {
    const instance = new MyClass();
    const registrar = new Registrar(instance);
    const app = new App();
    registrar.performTopActions(app);
    expect(instance.foo).toBe(1);
    expect(instance.bar).toBe(2);
  });

  it('should be applied to the class and its subclasses', () => {
    const instance = new MyAnotherClass();
    const registrar = new Registrar(instance, MyClass);
    const app = new App();
    registrar.performTopActions(app);
    expect(instance.foo).toBe(1);
    expect(instance.bar).toBe(2);
    expect(instance.baz).toBe(3);
  });

  it('should not be applied to the unrelated class', () => {
    const instance = new UnrelatedClass();
    const registrar = new Registrar(instance);
    const app = new App();
    registrar.performTopActions(app);
    expect(instance.foo).toBe(0);
    expect(instance.bar).toBe(0);
  });
});
