import { MappingStruct } from '../def';
import { renderObject } from '../utility';

export class AbstractRegistry<M extends Record<string | number | symbol, any>> {
  private map = new Map<keyof M, any>();

  extend<K extends keyof M>(name: K, value: M[K]) {
    this.map.set(name, value);
    return;
  }

  get<K extends keyof M>(name: K): M[K] {
    return this.map.get(name) as M[K];
  }
}

export type MethodType<T, R = any, EXT extends any[] = []> = (
  data: T,
  ...ext: EXT
) => R;

export type MethodMap<
  M extends Record<string | number | symbol, any>,
  R = any,
  EXT extends any[] = [],
> = {
  [K in keyof M]: MethodType<M[K], R, EXT>;
};

export class MethodRegistry<
  M extends Record<string | number | symbol, any>,
  R = any,
  EXT extends any[] = [],
> extends AbstractRegistry<MethodMap<M, R, EXT>> {
  execute<K extends keyof M>(info: MappingStruct<M, K>, ...ext: EXT) {
    if (!info) {
      return;
    }
    const fun = this.get(info.type);
    if (!fun) {
      return;
    }
    return fun(info.data, ...ext);
  }
}
