import {
  KoishiDoRegister,
  KoishiDoRegisterKeys,
  KoishiOnContextScope,
} from './def';
import { reflector } from './meta/meta-fetch';
import { Context } from 'koishi';
import {
  generateRenderer,
  getContextFromFilters,
  renderObject,
} from './utility';
import { DoRegister } from './registry';
import _ from 'lodash';

export interface DoRegisterResult<T> extends DoRegister.Config {
  key: keyof T & string;
  result: any;
}

export class Registrar<T = any> {
  constructor(
    private obj: T,
    private alternativeObject?: any,
    private view: Record<any, any> = {},
  ) {}

  getAllFieldsToRegister(): (keyof T)[] {
    const arr = reflector.getArray(KoishiDoRegisterKeys, this.obj);
    return arr as (keyof T)[];
  }

  getScopeContext(ctx: Context, key?: keyof T, autoScope = true) {
    if (key && autoScope) {
      ctx = this.getScopeContext(ctx);
    }
    let contextFilters = reflector.getArray(
      KoishiOnContextScope,
      this.obj,
      key as string,
    );
    if (this.alternativeObject) {
      contextFilters = contextFilters.concat(
        reflector.getArray(
          KoishiOnContextScope,
          this.alternativeObject,
          key as string,
        ),
      );
    }
    return getContextFromFilters(ctx, contextFilters);
  }

  register(
    ctx: Context,
    key: keyof T,
    autoScope = true,
    extraView: Record<any, any> = {},
  ): DoRegisterResult<T> {
    if (autoScope) {
      ctx = this.getScopeContext(ctx, key, true);
    }
    const _key = key as string;
    let data = reflector.get(KoishiDoRegister, this.obj, _key);
    if (!data) return;
    const totalView = { ...this.view, ...extraView };
    data = renderObject(data, totalView);
    const result = DoRegister.registry.execute(
      data,
      ctx,
      this.obj,
      _key,
      this.alternativeObject,
      totalView,
    );
    return { ...data, key: key as keyof T & string, result };
  }

  registerAll(
    ctx: Context,
    autoScope = false,
    extraView: Record<any, any> = {},
  ) {
    if (autoScope) {
      ctx = this.getScopeContext(ctx);
    }
    this.performTopActions(ctx, false);
    return this.getAllFieldsToRegister().map((key) =>
      this.register(ctx, key, true, extraView),
    );
  }

  performTopActions(
    ctx: Context,
    autoScope = false,
    extraView: Record<any, any> = {},
  ) {
    if (autoScope) {
      ctx = this.getScopeContext(ctx);
    }
    let actions = reflector.getArray('KoishiTopLevelAction', this.obj);
    if (this.alternativeObject) {
      actions = actions.concat(
        reflector.getArray('KoishiTopLevelAction', this.alternativeObject),
      );
    }
    actions = _.uniq(actions);
    const renderer = generateRenderer({ ...this.view, ...extraView });
    actions.forEach((action) => action(ctx, this.obj, renderer));
  }
}
