import {
  CommandDescription,
  PutOption,
  PutTemplate,
  UseCommand,
} from '../src/decorators';
import { Renderer } from '../src/def';
import { Registrar } from '../src/register';
import { App, Command } from 'koishi';
import { Session } from 'koishi';

class MyClass {
  @UseCommand('echo')
  @CommandDescription({ zh: '描述', en: 'description' })
  async onEcho(
    @PutOption('content', '-c <content:string>') content: string,
    @PutTemplate('content', { zh: '机器人: {content}', en: 'Robot: {content}' })
    renderer: Renderer<{ content: string }>,
  ) {
    return renderer({ content });
  }
}

const registrar = new Registrar(new MyClass());

describe('Register', () => {
  for (const locale of [
    { locale: 'zh', prefix: '机器人' },
    { locale: 'en', prefix: 'Robot' },
  ]) {
    it('should register command', async () => {
      const app = new App({ locale: locale.locale });
      await app.start();
      const result = registrar.register(app, 'onEcho');
      const command: Command = result.result;
      expect(
        command.execute({
          options: { content: 'hello' },
          session: {
            text(path, params) {
              return app.i18n.text(
                [locale.locale],
                [`commands.echo.messages${path}`],
                params,
              );
            },
          } as Session,
        }),
      ).resolves.toBe(`${locale.prefix}: hello`);
    });
  }
});
