import { App } from 'koishi';
import { Get } from '../src/decorators';
import { KoaContext } from '../src/def';
import request from 'supertest';
import { Registrar } from '../src/register';

class MyClass {
  @Get('ping')
  async ping(ctx: KoaContext) {
    ctx.status = 233;
    ctx.body = 'pong';
  }
}

const registrar = new Registrar(new MyClass());

describe('Http Routes', () => {
  let app: App;
  beforeEach(() => {
    app = new App();
  });

  it('should be able to get a route', async () => {
    registrar.register(app, 'ping');
    await app.start();
    return request(app._httpServer).get('/ping').expect(233).expect('pong');
  });
});
