import { Context } from 'koishi';
import { ContextSelector, OnContextFunction } from '../def';

export function applySelector(
  ctx: Context,
  selector: ContextSelector,
): Context {
  if (!selector) {
    return ctx;
  }
  let targetCtx = ctx;
  if (selector.select) {
    targetCtx = targetCtx.select(selector.select);
  }
  if (selector.useSelector) {
    targetCtx = selector.useSelector(targetCtx) || targetCtx;
  }
  return targetCtx;
}

export function getContextFromFilters(
  ctx: Context,
  filters: OnContextFunction[],
) {
  let targetCtx = ctx;
  for (const fun of filters) {
    targetCtx = fun(targetCtx) || targetCtx;
  }
  return targetCtx;
}
