import {
  KoishiDoRegister,
  KoishiDoRegisterKeys,
  KoishiOnContextScope,
} from './def';
import { reflector } from './meta/meta-fetch';
import { Context } from 'koishi';
import { getContextFromFilters } from './utility';
import { DoRegister } from './registry';

export interface DoRegisterResult<T> extends DoRegister.Config {
  key: keyof T & string;
  result: any;
}

export class Registrar<T = any> {
  constructor(private obj: T, private alternativeObject?: any) {}

  getAllFieldsToRegister(): (keyof T)[] {
    const arr = reflector.getArray(KoishiDoRegisterKeys, this.obj);
    return arr as (keyof T)[];
  }

  getScopeContext(ctx: Context, key?: keyof T, autoScope = true) {
    if (key && autoScope) {
      ctx = this.getScopeContext(ctx);
    }
    let contextFilters = reflector.getArray(
      KoishiOnContextScope,
      this.obj,
      key as string,
    );
    if (this.alternativeObject) {
      contextFilters = contextFilters.concat(
        reflector.getArray(
          KoishiOnContextScope,
          this.alternativeObject,
          key as string,
        ),
      );
    }
    return getContextFromFilters(ctx, contextFilters);
  }

  register(ctx: Context, key: keyof T, autoScope = true): DoRegisterResult<T> {
    if (autoScope) {
      ctx = this.getScopeContext(ctx, key, true);
    }
    const _key = key as string;
    const data = reflector.get(KoishiDoRegister, this.obj, _key);
    if (!data) return;
    const result = DoRegister.registry.execute(
      data,
      ctx,
      this.obj,
      _key,
      this.alternativeObject,
    );
    return { ...data, key: key as keyof T & string, result };
  }

  registerAll(ctx: Context, autoScope = false) {
    if (autoScope) {
      ctx = this.getScopeContext(ctx);
    }
    return this.getAllFieldsToRegister().map((key) =>
      this.register(ctx, key, true),
    );
  }
}
