import path from 'path';
import fs from 'fs';
import { Logger } from 'koishi';
import ConfigLoader from '@koishijs/loader';
import { KoishiConfig } from './def/interfaces';

const logger = new Logger('bootstrap-prod');

async function handlePackageEntry(packagePath: string) {
  const packagesToRemove = ['koishi', '@koishijs/core', '@koishijs/utils'].map(
    (p) => path.join(packagePath, 'node_modules', p),
  );
  await Promise.all(
    packagesToRemove.map(async (path) => {
      try {
        await fs.promises.access(path);
        logger.info(`Removing ${path} ...`);
        await fs.promises.rm(path, { recursive: true });
      } catch (e) {}
    }),
  );
}

export async function prodEntry() {
  logger.info(`Running production preparations...`);
  const config = new ConfigLoader().readConfig() as KoishiConfig;
  const plugins = config?.plugins;
  if (!plugins) {
    logger.warn(`No plugins found, exiting.`);
    return;
  }
  const pluginList = Object.keys(plugins).filter((name) =>
    name.startsWith('./'),
  );
  await Promise.all(pluginList.map((name) => handlePackageEntry(name)));
  logger.info(`Done.`);
}
