import { KoishiConfig } from '../def/interfaces';
import yaml from 'yaml';
import fs from 'fs';
import path from 'path';
import loadJsonFile from 'load-json-file';
import { Logger } from 'koishi';

const logger = new Logger('bootstrap-config-loader');

async function loadFromYaml(): Promise<KoishiConfig> {
  return yaml.parse(await fs.promises.readFile('./koishi.config.yml', 'utf-8'));
}

function loadFromJs(): KoishiConfig {
  return require(path.join(process.cwd(), 'koishi.config.js'));
}

async function loadFromJson(): Promise<KoishiConfig> {
  return await loadJsonFile('./koishi.config.json');
}

export async function loadConfig(): Promise<KoishiConfig | undefined> {
  try {
    logger.info(`Reading config from ./koishi.config.yml.`);
    return await loadFromYaml();
  } catch (e) {
    logger.warn(
      `Failed reading from YAML: ${(e as any).toString()} , trying JS.`,
    );
    logger.info(`Reading config from ./koishi.config.js.`);
    try {
      return loadFromJs();
    } catch (e) {
      logger.warn(
        `Failed reading from JS: ${(e as any).toString()} , trying JSON.`,
      );
      logger.info(`Reading config from ./koishi.config.json.`);
      try {
        return await loadFromJson();
      } catch (e) {
        logger.warn(
          `Failed reading from JSON: ${(e as any).toString()} , exiting.`,
        );
        return;
      }
    }
  }
}
