# Koishi Bootstrap

Koishi bootstrap script, for Docker.

## Docker

The docker image is at `git-registry.mycard.moe/3rdeye/koishi-bootstrap`.

Mount your config file, either `koishi.config.yml` or `koishi.config.js`, to `/app` , and run it.

## Auto plugin install

This Docker image will auto install every plugin mentioned in Koishi config file, whose config includes `$install` variable`.

`$install` variable could be as follows.

* `true` for latest version.

* a specific version name, eg. `^4.0.0-beta.1`.

## Config example

```yaml
port: 8080

logger:
  root: logs

allowWrite: false

# 插件设置
plugins:
  act:
    $install: latest
  adapter-onebot:
    $install: true # Will always install the latest version
    bots:
      - protocol: 'ws'
        endpoint: 'wss://example.com'
        selfId: '1111111111'
        token: 'token'
  verifer:
    $install: '1.0.0-beta.0' # Will install this version. NPM format is also supported.
```