import path from 'path';
import { getPackageJsonPackages } from './utils/read-package-json';
import fs from 'fs';

async function handlePackageEntry(packageName: string, versionString: string) {
  if (!versionString.startsWith('file:')) {
    return;
  }
  console.log(`Cleaning package ${packageName}...`);
  const packagePath = versionString.slice(5);
  const packagesToRemove = ['koishi', '@koishijs/core', '@koishijs/utils'].map(
    (p) => path.join(packagePath, 'node_modules', p),
  );
  await Promise.all(
    packagesToRemove.map(async (path) => {
      try {
        await fs.promises.access(path);
        console.log(`Removing ${path} ...`);
        // await fs.promises.rmdir(path, { recursive: true });
      } catch (e) {}
    }),
  );
}

export async function prodEntry() {
  console.log(`Running production preparations...`);
  const deps = await getPackageJsonPackages();
  const entries = Object.entries(deps);
  await Promise.all(
    entries.map((entry) => handlePackageEntry(entry[0], entry[1])),
  );
  console.log(`Done.`);
}
