import { getRules } from '../src';

describe('IP PCC', () => {
  it('should work in basic form', () => {
    const result = getRules([1, 1]);
    expect(result.length).toBe(2);
    expect(result.every((gatewayRule) => gatewayRule.length === 2)).toBe(true);
    expect(
      result.every(
        (gatewayRule) =>
          gatewayRule.filter((rule) => rule.src === '0.0.0.0/0.0.0.1')
            .length === 1,
      ),
    ).toBe(true);
  });

  it('Should factorize result', () => {
    expect(getRules([1, 1, 1, 1])).toEqual(getRules([2, 2, 2, 2]));
  });
});
