import { Injectable, ConsoleLogger } from '@nestjs/common';
import { ConfigService } from '@nestjs/config';
import { InjectAragami } from 'nestjs-aragami';
import { Aragami } from 'aragami';
import { TicketDto, TicketReq } from './dto/ticket.dto';
import { BlankReturnMessageDto } from './dto/ReturnMessage.dto';

@Injectable()
export class AppService extends ConsoleLogger {
  constructor(
    private readonly config: ConfigService,
    @InjectAragami() private readonly aragami: Aragami,
  ) {
    super('ticket');
  }

  async submitTicket(dto: TicketDto) {
    await this.aragami.set(dto);
    this.log(`Ticket ${dto.id} submitted ticket of ${dto.ticket}`);
    return dto;
  }

  async getTicket(req: TicketReq) {
    const dto = await this.aragami.get(TicketDto, req.id);
    if (!dto) {
      throw new BlankReturnMessageDto(404, 'Ticket not found.').toException();
    }
    return dto;
  }
}
