import {
  Controller,
  Get,
  Header,
  Post,
  Query,
  ValidationPipe,
} from '@nestjs/common';
import { AppService } from './app.service';
import {
  ApiCreatedResponse,
  ApiOkResponse,
  ApiOperation,
  ApiProduces,
} from '@nestjs/swagger';
import { StaticService } from './static/static.service';
import { TicketDto, TicketReq } from './dto/ticket.dto';

@Controller()
export class AppController {
  constructor(
    private readonly appService: AppService,
    private readonly staticService: StaticService,
  ) {}

  @Get()
  @ApiProduces('text/html')
  @ApiOperation({ summary: 'Get captcha page' })
  @Header('Content-Type', 'text/html')
  @Header('Cache-Control', 'max-age=86400, public')
  getHello(@Query() payload: any) {
    return this.staticService.getCaptchaHtml(payload);
  }

  @Post('ticket')
  @ApiOperation({ summary: 'Submit ticket' })
  @ApiCreatedResponse({ type: TicketDto })
  submitTicket(@Query(new ValidationPipe({ transform: true })) dto: TicketDto) {
    return this.appService.submitTicket(dto);
  }

  @Get('ticket')
  @ApiOperation({ summary: 'Get ticket' })
  @ApiOkResponse({ type: TicketDto })
  getTicket(@Query(new ValidationPipe({ transform: true })) dto: TicketReq) {
    return this.appService.getTicket(dto);
  }
}
