import { ConsoleLogger, Injectable } from '@nestjs/common';
import * as fs from 'fs';

@Injectable()
export class StaticService extends ConsoleLogger {
  constructor() {
    super('Static');
  }
  private content = '';

  async onModuleInit() {
    this.content = await fs.promises.readFile('./captcha.html', 'utf-8');
  }

  getCaptchaHtml(payload: any) {
    this.log(`User ${JSON.stringify(payload)} is requesting captcha page.`);
    return this.content;
  }
}
